<?php

namespace TypechoPlugin\UserLog;

use Typecho\Plugin\PluginInterface;
use Utils\Helper;
use Typecho\Widget\Helper\Form;
use Typecho\Widget\Helper\Form\Element\Text;
use Widget\Options;

if (!defined('__TYPECHO_ROOT_DIR__')) {
    exit;
}

/**
 * 用户登录日志插件重构版，要求Typecho1.2及以上版本
 *
 * @package UserLog
 * @author 泽泽社长
 * @version 1.0.7
 * @link https://blog.zezeshe.com/archives/userlog-typecho-plugin.html
 */
class Plugin implements PluginInterface
{
    /**
     * 激活插件方法,如果激活失败,直接抛出异常
     */
    public static $panel  = 'UserLog/panel.php';
    
    public static function activate()
    {
        //用户登录完成
        \Typecho\Plugin::factory('Widget_User')->loginSucceed = __CLASS__ . '::loginlog';
        
        //用户通过插件登录完成
        \Typecho\Plugin::factory('Widget_User')->simpleLoginSucceed = __CLASS__ . '::simpleloginlog';
        Helper::addPanel(1, self::$panel, '用户登录日志', '用户登录日志', 'editor');
    }

    /**
     * 禁用插件方法,如果禁用失败,直接抛出异常
     */
    public static function deactivate()
    {
        Helper::removePanel(1, self::$panel); 
    }

    /**
     * 获取插件配置面板
     *
     * @param Form $form 配置面板
     */
    public static function config(Form $form)
    {
    }

    /**
     * 个人用户的配置面板
     *
     * @param Form $form
     */
    public static function personalConfig(Form $form)
    {
    }

    /**
     * 插件实现方法
     *
     * @access public
     * @return void
     * $type为0则为常规登录，为1则为通过插件进行的登录(一般为社交登录)
     */
    public static function savehistory($user,$type="0"){
        date_default_timezone_set("Asia/Chongqing"); // PRC为中华人名共和国
        $time=time();
        $jsonFile=__DIR__ . '/history/all.json';
        if($type=='0'){
        $userhistory=array(
            'uid' => $user->uid,
            'name' => $user->name,
            'screenName' =>$user->screenName, 
            'times' => $time, 
            'status'=>$type
            );
        }else{
        $userhistory=array(
            'uid' => $user['uid'],
            'name' => $user['name'],
            'screenName' =>$user['screenName'], 
            'times' => $time, 
            'status'=>$type
            );
        }
        if (file_exists($jsonFile)){
        
            $jsonStr = file_get_contents($jsonFile);
            $array = json_decode($jsonStr, true);
            array_unshift($array, $userhistory);
            $jsonData = json_encode($array);
        
        }else{
            
            $userhistoryx[]=$userhistory;
            $jsonData = json_encode($userhistoryx);
        }
        
        
        file_put_contents($jsonFile, $jsonData);

    }
    
    public static function loginlog($user,$name,$pwd,$remember)
    {
        self::savehistory($user);
    }
    public static function simpleloginlog($obj,$user){
        self::savehistory($user,'1');
    }
}
