<?php

namespace TypechoPlugin\CalendarGraph;

use Typecho\Common;
use Typecho\Db;
use Typecho\Db\Exception;
use Typecho\Plugin\PluginInterface;
use Typecho\Widget\Helper\Form;
use Typecho\Widget\Helper\Form\Element\Text;
use Widget\Options;

/**
 * 生成从去年的今天开始到当前日期的graph（类似gitub的热图）。
 * @package 热图生成
 * @author gouki
 * @version 0.0.1
 * @link https://neatstudio.com
 */
class Plugin implements PluginInterface
{
    public static $graphStatData;
    public static $calendarData;

    /**
     * 激活插件方法,如果激活失败,直接抛出异常
     */
    public static function activate()
    {
        //如果需要自定义配置，可以参考下面的代码
        \Typecho\Plugin::factory('index.php')->renderGraph = __CLASS__.'::renderGraph';
        \Typecho\Plugin::factory('index.php')->renderCalendar = __CLASS__.'::renderCalendar';
    }

    /**
     * 禁用插件方法,如果禁用失败,直接抛出异常
     */
    public static function deactivate()
    {
    }

    /**
     * 获取插件配置面板
     * @param  Form  $form  配置面板
     */
    public static function config(Form $form)
    {
        /** 分类名称 */
        $name = new Text('word', null, 'Hello World', _t('说点什么'));
        $form->addInput($name);
    }

    /**
     * 个人用户的配置面板
     * @param  Form  $form
     */
    public static function personalConfig(Form $form)
    {
    }

    /**
     * @param $archive
     * @return void
     * @throws Db\Exception
     */
    public static function getGraphData()
    {
        if (!self::$graphStatData) {
            $db = Db::get();
            $options = Options::alloc();
            $resource = $db->query($db->select('created')->from('table.contents')
                                      ->where('type = ?', 'post')
                                      ->where('table.contents.status = ?', 'publish')
                                      ->where('table.contents.created > ?', strtotime("-1year"))
                                      ->order('table.contents.created', Db::SORT_ASC));
            $offset = $options->timezone - $options->serverTimezone;
            $result = [];
            while ($post = $db->fetchRow($resource)) {
                $timeStamp = $post['created'] + $offset;
                $date = date("Y-m-d", $timeStamp);
                if (isset($result[$date])) {
                    $result[$date]['count']++;
                } else {
                    $result[$date]['date'] = $date;
                    $result[$date]['count'] = 1;
                }
            }
            self::$graphStatData = array_values($result);
        }
        return self::$graphStatData;
    }

    public static function getCalendarData()
    {
        if (!self::$calendarData) {
            $db = Db::get();
            $options = Options::alloc();
            $resource = $db->query($db->select('created')->from('table.contents')
                                      ->where('type = ?', 'post')
                                      ->where('table.contents.status = ?', 'publish')
                                      ->where('table.contents.created > ?', strtotime(date("Y-m-01")))//本月1号起算
                                      ->order('table.contents.created', Db::SORT_ASC));
            $offset = $options->timezone - $options->serverTimezone;
            $result = [];
            while ($post = $db->fetchRow($resource)) {
                $timeStamp = $post['created'] + $offset;
                $m = date('d', $timeStamp);
                if (isset($month[$m])) {
                    $result[$m]++;
                } else {
                    $result[$m] = 1;
                }
            }
            self::$calendarData = $result;
        }
        return self::$calendarData;
    }

    /**
     * @return void
     * @throws Exception
     */
    public static function renderGraph()
    {
        $item = json_encode(self::getGraphData());
        $jsUrl = Options::alloc()->rootUrl.'/usr/plugins/CalendarGraph/bundle.js';
        $items = [];
        $items[] = "<style>
    #tooltip {zindex: 999;display: none;position: fixed;left: 0;top: 0;height: 25px;background-color: rgba(0, 0, 0, .8);color: #fff;padding: 4px 10px;border-radius: 3px;font-size: 12px}
    #tooltip:after {display: block;position: absolute;content: '';bottom: -6px;left: 50%;margin-left: -6px;width: 0; height: 0; border-left: 6px solid transparent;border-right: 6px solid transparent;border-top: 6px solid rgba(0, 0, 0, .8);}
    svg {width: 100%}</style>";
        $items[] = "<div id='svg' ></div><div id='tooltip'></div>";
        $items[] = "<script>const graphOption = {tooptipId: '#tooltip',graphId : '#svg' ,tooltipFormat: '{1}篇内容于{0}发表',graphData:{$item}, option: {}};</script>";
        $items[] = "<script src='$jsUrl' defer></script>";
        echo join("", $items);
    }

    public static function renderCalendar()
    {
        $calendarData = self::getCalendarData();
        $options = Options::alloc();
        $month = date('F');
        //测试用
        $firstWeekDate = date('w', strtotime(date("Y-m-01")));
        $items = [];
        $items[] = <<<EOT
<style>
    .calendar-wrapper{width:100%;line-height: 2}
    .calendar-wrapper .text-center{text-align: center}
    .calendar-wrapper .calendar {display: grid;grid-template-columns: repeat(7, 1fr);text-align: center;list-style-type: none;margin-block-start: 0;padding-inline:0}
    .calendar-wrapper .calendar>li{margin: 1px;}
    .calendar-wrapper .text-font-bold{font-weight: bold}
    .calendar-wrapper .today{background-color:#8d6feF;border-radius:0.25rem;color:#FFF}
    .calendar-wrapper .haspost{background-color:  #A5B4FC;border-radius: 0.25rem;color:#FFF}
    .calendar-wrapper .haspost a{color:#FFF}
</style>
<div class='calendar-wrapper'>
    <h1 class='text-center'>{$month}</h1>
    <ul class='calendar'>
        <li class='text-font-bold'>日</li>
        <li class='text-font-bold'>一</li>
        <li class='text-font-bold'>二</li>
        <li class='text-font-bold'>三</li>
        <li class='text-font-bold'>四</li>
        <li class='text-font-bold'>五</li>
        <li class='text-font-bold'>六</li>
EOT;
        for ($i = 0; $i < $firstWeekDate; $i++) {
            $items[] = ' <li>&nbsp;</li>';
        }
        foreach (range(1, date('t')) as $day) {
            $link = Common::url(date("Y/m/{$day}"), $options->index);
            $items[] = sprintf('<li class="%s %s">%s</li>', $day == date("d") ? 'today' : '', isset($calendarData[$day]) ? 'haspost' : '',
                isset($calendarData[$day]) ? ("<a href='{$link}' />".$day."</a>") : $day);
        }
        $items[] = "</ul></div>";
        echo join("", $items);
    }

    public static function test($archive)
    {
        echo "<pre>";
        print_r($archive->archiveSlug);
        echo "</pre>";
        echo "<hr />";
        echo "<pre>";
        print_r($archive);
        echo "</pre>";
        return $archive->pageRow;
    }
}
/*blade的用法
 *
    <style>#tooltip2 {zindex: 999;display: none;position: fixed;left: 0;top: 0;height: 20px;background-color: rgba(0, 0, 0, .8);color: #fff;padding: 4px 10px;border-radius: 3px;}
        #tooltip2:after {display: block;position: absolute;content: '';bottom: -6px;left: 50%;margin-left: -6px;width: 0; height: 0; border-left: 6px solid transparent;border-right: 6px solid transparent;border-top: 6px solid rgba(0, 0, 0, .8);}
        svg {width: 100%}
    </style>
    <div id="svg"></div>
    <div id="tooltip"></div>
    <script>
         const graphOption = {
            tooptipId: 'tooltip',
            graphId: '#svg',
            tooltipFormat: '{1}篇内容于{0}发表',
            graphData: {!! json_encode($view->graphStatData) !!},
            graphOptions: {}
        };
    </script>
    <script src="{{$options->rootUrl.'/usr/plugins/CalendarGraph/bundle.js'}}" defer></script>
 */
/* php的用法，其实也就是普通的用法
    <style>#tooltip2 {zindex: 999;display: none;position: fixed;left: 0;top: 0;height: 20px;background-color: rgba(0, 0, 0, .8);color: #fff;padding: 4px 10px;border-radius: 3px;}
        #tooltip2:after {display: block;position: absolute;content: '';bottom: -6px;left: 50%;margin-left: -6px;width: 0; height: 0; border-left: 6px solid transparent;border-right: 6px solid transparent;border-top: 6px solid rgba(0, 0, 0, .8);}
        svg {width: 100%}
    </style>
    <div id="svg"></div>
    <div id="tooltip"></div>
    <script>
         const graphOption = {
            tooptipId: 'tooltip',
            graphId: '#svg',
            tooltipFormat: '{1}篇内容于{0}发表',
            graphData: <?php echo json_encode($view->graphStatData);?>,
            graphOptions: {}
        };
    </script>
    <script src="<?php echo $options->rootUrl;?>/usr/plugins/CalendarGraph/bundle.js" defer></script>

*/