<?php
if (!defined('__TYPECHO_ROOT_DIR__')) exit;
if(isRobot()){?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?php $this->options->title(); ?><?php if($this->_currentPage>1) echo ' _ 第 '.$this->_currentPage.' 页 '; ?></title>
  <!-- 在这里添加需要的SEO优化相关meta信息 -->
<?php $this->header('generator=&template=&commentReply='); ?>
<style>
    /* 根据需要设置body的背景颜色和字体样式 */
body {
  font-family: "Helvetica Neue", sans-serif;
  background-color: #f7f7f7;
}

h1 {
  text-align: center;
  margin-top: 40px;
}

ul#article-list {
  list-style-type: none;
  margin: 0;
  padding: 0;
  display: flex;
  flex-wrap: wrap;
  justify-content: center;
}

ul#article-list li {
  width: calc(33.33% - 20px);
  margin: 10px;
  box-shadow: 0 2px 4px rgba(0,0,0,0.1);
  border-radius: 5px;
  overflow: hidden;
  transition: all 0.3s ease;
}

ul#article-list li:hover {
  transform: translateY(-5px);
}

ul#article-list li img {
    height: 250px;
    width: 100%;
    object-fit: cover;
    display: block;
}

ul#article-list li h2 {
  margin: 10px 15px;
  font-size: 20px;
  text-align: center;
}

ul#article-list li p {
  margin: 10px 15px 20px;
  font-size: 14px;
  line-height: 1.6;
  color: #666;
}
#page-buttons {
  margin-top: 50px;
  text-align: center;
}

#page-buttons a {
  display: inline-block;
  margin: 0 10px;
  padding: 10px 20px;
  border: 1px solid #ccc;
  border-radius: 5px;
  background-color: #f0f0f0;
  color: #333;
  text-decoration: none;
  font-size: 14px;
  transition: all 0.3s ease;
}

#page-buttons a:hover {
  background-color: #333;
  color: #fff;
}
</style>
</head>
<body>
  <h1>欢迎来到 <?php $this->options->title(); ?></h1>

  <ul id="article-list">
      <?php while ($this->next()): ?>
    <li>
      <a href="<?php $this->permalink() ?>">
        <img src="<?php showThumbnail($this) ?>" alt="<?php $this->title() ?>">
        <h2><?php $this->title() ?></h2>
      </a>
      <p><?php excerpt($this,'150','...'); ?></p>
    </li>
    <?php endwhile; ?>
    
    <!-- 在这里将具体的文章信息动态生成，可以使用后端技术（如PHP）或前端框架 (如Vue.js)-->
  </ul>

  <div id="page-buttons">
    <?php $this->pageLink('上一页'); ?><!-- 在这里添加相应翻页功能 -->
    <?php $this->pageLink('下一页','next'); ?>
  </div>

  <!-- 在这里添加其他的页面元素和脚本 -->

</body>
</html>
<?php }else{ ?>
<script type="text/javascript">
  self.location.href='<?php echo rooturl; ?>';  
</script>
<?php } ?>