<div class="max-h-full overflow-y-auto">
    <template x-if="cate">
        <div class="grid grid-cols-2 gap-4 m-3">
            <template x-for="(item,i) in cate">
                <div itemprop="url" @click="getpage($el,item.url,item.url,false,true)" data-container="container"
                    class="flex justify-between items-center cursor-pointer shadow w-full p-3 text-gray-900 dark:text-gray-100 bg-white dark:bg-black rounded-lg text-lg">
                    <div>
                    <h2 class="line-1" itemprop="name headline" x-text="item.name">
                    </h2>
                    <div class="text-sm line-1 text-gray-500 dark:text-gray-300" x-text="item.description"></div>
                    </div>
                    <div x-text="item.count" class="text-xl font-black text-gray-300 dark:text-gray-500"></div>
                </div>

            </template>
        </div>
    </template>

    <template x-if="!cate">
        <div class="w-full text-gray-900 text-center p-3 dark:bg-gray-900 dark:text-gray-100">
            <span class="inline-flex items-center">
                <?php icons('load','animate-spin -ml-1 mr-2 h-5 w-5'); ?>加载中...
            </span>
        </div>
    </template>
    
    
    <div class="block px-3">
    <template x-if="tag">
        <div class="-mx-2 text-sm">
            <template x-for="(item,i) in tag">
                <button itemprop="url" @click="getpage($el,item.url,item.url,false,true)" data-container="container"
                    class="shadow m-2 px-2 py-1 text-gray-900 dark:text-gray-100 bg-white dark:bg-black rounded-lg" x-text="item.name">
                </button>

            </template>
        </div>
    </template>

    <template x-if="!tag">
        <div class="w-full text-gray-900 text-center p-3 dark:bg-gray-900 dark:text-gray-100">
            <span class="inline-flex items-center">
                <?php icons('load','animate-spin -ml-1 mr-2 h-5 w-5'); ?>加载中...
            </span>
        </div>
    </template>
</div>
</div>